import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.response.RelatedBusinessInfo;
import org.uddi4j.response.RelatedBusinessInfos;
import org.uddi4j.response.RelatedBusinessesList;
import org.uddi4j.response.SharedRelationships;
import org.uddi4j.transport.TransportFactory;
import org.uddi4j.util.KeyedReference;
import java.util.Vector;

public class UDDIFindRelatedBusinesses1 {

	public static void main(String[] args) throws Exception {

		System.setProperty(TransportFactory.PROPERTY_NAME, "org.uddi4j.transport.ApacheAxisTransport");

		UDDIProxy proxy = new UDDIProxy();
		proxy.setInquiryURL("http://uddi.microsoft.com/inquire");

		Vector cbv = new Vector();
		KeyedReference kr = new KeyedReference("peer-peer", "peer-peer");
	 	kr.setTModelKey(TModel.RELATIONSHIPS_TMODEL_KEY);

		RelatedBusinessesList rbl = proxy.find_relatedBusinesses("ee7a7a30-f67c-11d6-b618-000629dc0a53", kr, null, 0);

		RelatedBusinessInfos rbis = rbl.getRelatedBusinessInfos();
		if (rbis.size() == 0) {
			System.out.println("no related business(es) found");
			System.exit(0);
		}

		System.out.println(rbis.size()+" related business(es) found\n");
		Vector rbiv = rbis.getRelatedBusinessInfoVector();
		for (int i = 0; i < rbiv.size(); i++) {
			RelatedBusinessInfo rbi = (RelatedBusinessInfo)rbiv.elementAt(i);
			System.out.println(rbi.getNameString());
			System.out.println(rbi.getBusinessKey());
			System.out.println("\n");
			SharedRelationships srs = rbi.getSharedRelationships();
			System.out.println("direction : "+srs.getDirection());
			Vector krv = srs.getKeyedReferenceVector();
			System.out.println(krv.size()+" shared relationship(s) found\n");
			for (int j = 0; j < krv.size(); j++) {
				kr = (KeyedReference)krv.elementAt(j);
				System.out.println("name  : "+kr.getKeyName());
				System.out.println("value : "+kr.getKeyValue());
				System.out.println("\n");
			}
		}
	}
}